##
# __init__.py: Root module for the gardenpath library.
##
# This module is part of the gardenpath package,
# developed under the rereading Project (https://rereading.space).
#
# Copyright 2025, rereading Project. Licensed under the GNU AGPL v3.
##

import gardenpath._gardenpath_bind as _impl
from typing import Optional, Literal

DocumentFormat = Literal["html5", "xml"]


def parse_document(
    data: str, format: DocumentFormat = "html5", line_num_attr: Optional[str] = None
):
    match format:
        case "html5":
            return _impl.parse_html5_document(data, line_num_attr=line_num_attr)

        case "xml":
            raise NotImplementedError("Not yet implemented.")

        case _ as unknown:
            raise ValueError(f"Document format {unknown} not known.")
